﻿using System;
using Habanero.BO;
using System.Linq;

namespace BobsPizzaPlace.BO
{
    public class Order : BusinessObject
    {
        

        public virtual int OrderNumber
        {
            get { return ((int)(base.GetPropertyValue("OrderNumber"))); }
            set { base.SetPropertyValue("OrderNumber", value); }
        }

        public virtual BusinessObjectCollection<OrderItem> OrderItems
        {
            get
            {
                return Relationships.GetRelatedCollection<OrderItem>("OrderItems");
            }
        }

        public decimal Total
        {
            get { return OrderItems.Sum(item => item.Subtotal); }
        }
    }
}
